// Decompiled by DJ v3.7.7.81 Copyright 2004 Atanas Neshkov  Date: 05/07/2005 07:42:23 p.m.
// Home Page : http://members.fortunecity.com/neshkov/dj.html  - Check often for new version!
// Decompiler options: packimports(3) 

package nu.xom;

import java.io.*;
import java.util.Locale;

// Referenced classes of package nu.xom:
//            EBCDICWriter, Text, Attribute, Element, 
//            UnicodeWriter, Comment, ProcessingInstruction, DocType, 
//            XMLException, TextWriterFactory, TextWriter, Document, 
//            Node, ParentNode

public class Serializer
{

    public Serializer(OutputStream outputstream)
    {
        preserveBaseURI = false;
        if(outputstream == null)
            throw new NullPointerException("Null OutputStream");
        try
        {
            Object obj = new OutputStreamWriter(outputstream, "UTF8");
            obj = new BufferedWriter(((java.io.Writer) (obj)));
            escaper = TextWriterFactory.getTextWriter(((java.io.Writer) (obj)), "UTF-8");
        }
        catch(UnsupportedEncodingException unsupportedencodingexception)
        {
            throw new RuntimeException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream outputstream, String s)
        throws UnsupportedEncodingException
    {
        preserveBaseURI = false;
        if(outputstream == null)
            throw new NullPointerException("Null OutputStream");
        if(s == null)
        {
            throw new NullPointerException("Null encoding");
        } else
        {
            setOutputStream(outputstream, s);
            return;
        }
    }

    public void setOutputStream(OutputStream outputstream)
        throws IOException
    {
        flush();
        int i = getMaxLength();
        int j = getIndent();
        String s = getLineSeparator();
        boolean flag = getUnicodeNormalizationFormC();
        String s1 = escaper.getEncoding();
        setOutputStream(outputstream, s1);
        setIndent(j);
        setMaxLength(i);
        setUnicodeNormalizationFormC(flag);
        setLineSeparator(s);
    }

    private void setOutputStream(OutputStream outputstream, String s)
        throws UnsupportedEncodingException
    {
        String s1 = s.toUpperCase(Locale.ENGLISH);
        Object obj;
        if(s1.equals("IBM037") || s1.equals("CP037") || s1.equals("EBCDIC-CP-US") || s1.equals("EBCDIC-CP-CA") || s1.equals("EBCDIC-CP-WA") || s1.equals("EBCDIC-CP-NL") || s1.equals("CSIBM037"))
            obj = new EBCDICWriter(outputstream);
        else
        if(s1.equals("UTF-16") || s1.equals("ISO-10646-UCS-2"))
            obj = new OutputStreamWriter(outputstream, "UnicodeBig");
        else
        if(s1.equals("ISO-8859-11") || s1.equals("TIS-620"))
            obj = new OutputStreamWriter(outputstream, "TIS620");
        else
            obj = new OutputStreamWriter(outputstream, s);
        obj = new BufferedWriter(((java.io.Writer) (obj)));
        escaper = TextWriterFactory.getTextWriter(((java.io.Writer) (obj)), s);
    }

    public void write(Document document)
        throws IOException
    {
        escaper.reset();
        writeXMLDeclaration();
        int i = document.getChildCount();
        for(int j = 0; j < i; j++)
        {
            writeChild(document.getChild(j));
            escaper.breakLine();
        }

        escaper.flush();
    }
    
    public void writeHTML(Document document)
        throws IOException
    {
        escaper.reset();
        int i = document.getChildCount();
        for(int j = 0; j < i; j++)
        {
            writeChild(document.getChild(j));
            escaper.breakLine();
        }

        escaper.flush();
    }
    

    protected void writeXMLDeclaration()
        throws IOException
    {
        escaper.writeMarkup("<?xml version=\"1.0\" encoding=\"");
        escaper.writeMarkup(escaper.getEncoding());
        escaper.writeMarkup("\"?>");
        escaper.breakLine();
    }

    protected void write(Element element)
        throws IOException
    {
        if(escaper.isIndenting() && !escaper.isPreserveSpace() && !escaper.justBroke())
            escaper.breakLine();
        boolean flag = false;
        int i = element.getChildCount();
        int j = 0;
label0:
        do
        {
label1:
            {
                if(j >= i)
                    break label0;
                Node node = element.getChild(j);
                if(node.isText())
                {
                    Text text = (Text)node;
                    if(text.isEmpty())
                        break label1;
                }
                flag = true;
                break label0;
            }
            j++;
        } while(true);
        if(flag)
        {
            writeStartTag(element);
            boolean flag1 = escaper.isPreserveSpace();
            String s = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
            if(s != null)
                if("preserve".equals(s))
                    escaper.setPreserveSpace(true);
                else
                if("default".equals(s))
                    escaper.setPreserveSpace(false);
            escaper.incrementIndent();
            for(int k = 0; k < i; k++)
                writeChild(element.getChild(k));

            escaper.decrementIndent();
            if(escaper.getIndent() > 0 && !escaper.isPreserveSpace() && hasNonTextChildren(element))
                escaper.breakLine();
            writeEndTag(element);
            if(s != null)
                escaper.setPreserveSpace(flag1);
        } else
        {
            writeEmptyElementTag(element);
        }
        escaper.flush();
    }

    private boolean hasNonTextChildren(Element element)
    {
        int i = element.getChildCount();
        for(int j = 0; j < i; j++)
            if(!element.getChild(j).isText())
                return true;

        return false;
    }

    protected void writeEndTag(Element element)
        throws IOException
    {
        escaper.writeMarkup("</");
        escaper.writeMarkup(element.getQualifiedName());
        escaper.writeMarkup(">");
    }

    protected void writeStartTag(Element element)
        throws IOException
    {
        writeTagBeginning(element);
        escaper.writeMarkup('>');
    }

    protected void writeEmptyElementTag(Element element)
        throws IOException
    {
        writeTagBeginning(element);
        escaper.writeMarkup("/>");
    }

    private void writeTagBeginning(Element element)
        throws IOException
    {
        escaper.writeMarkup('<');
        escaper.writeMarkup(element.getQualifiedName());
        writeAttributes(element);
        writeNamespaceDeclarations(element);
    }

    protected void writeAttributes(Element element)
        throws IOException
    {
        if(preserveBaseURI)
        {
            ParentNode parentnode = element.getParent();
            if(element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null)
            {
                String s = element.getBaseURI();
                if(parentnode == null || parentnode.isDocument() || !element.getBaseURI().equals(parentnode.getBaseURI()))
                {
                    escaper.writeMarkup(' ');
                    Attribute attribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", s);
                    write(attribute);
                }
            }
        }
        int i = element.getAttributeCount();
        for(int j = 0; j < i; j++)
        {
            Attribute attribute1 = element.getAttribute(j);
            escaper.writeMarkup(' ');
            write(attribute1);
        }

    }

    protected void writeNamespaceDeclarations(Element element)
        throws IOException
    {
        ParentNode parentnode = element.getParent();
        int i = element.getNamespaceDeclarationCount();
        for(int j = 0; j < i; j++)
        {
            String s = element.getNamespacePrefix(j);
            String s1 = element.getNamespaceURI(s);
            Element element1;
            if(parentnode.isElement() ? !s1.equals((element1 = (Element)parentnode).getNamespaceURI(s)) : !s1.equals(""))
            {
                escaper.writeMarkup(' ');
                writeNamespaceDeclaration(s, s1);
            }
        }

    }

    protected void writeNamespaceDeclaration(String s, String s1)
        throws IOException
    {
        if("".equals(s))
        {
            escaper.writeMarkup("xmlns");
        } else
        {
            escaper.writeMarkup("xmlns:");
            escaper.writeMarkup(s);
        }
        escaper.writeMarkup("=\"");
        escaper.writePCDATA(s1);
        escaper.writeMarkup('"');
    }

    protected void write(Attribute attribute)
        throws IOException
    {
        escaper.writeMarkup(attribute.getQualifiedName());
        escaper.writeMarkup("=\"");
        escaper.writeAttributeValue(attribute.getValue());
        escaper.writeMarkup('"');
    }

    protected void write(Comment comment)
        throws IOException
    {
        if(escaper.isIndenting())
            escaper.breakLine();
        escaper.writeMarkup("<!--");
        escaper.writeMarkup(comment.getValue());
        escaper.writeMarkup("-->");
    }

    protected void write(ProcessingInstruction processinginstruction)
        throws IOException
    {
        if(escaper.isIndenting())
            escaper.breakLine();
        escaper.writeMarkup("<?");
        escaper.writeMarkup(processinginstruction.getTarget());
        String s = processinginstruction.getValue();
        if(!"".equals(s))
        {
            escaper.writeMarkup(' ');
            escaper.writeMarkup(s);
        }
        escaper.writeMarkup("?>");
    }

    protected void write(Text text)
        throws IOException
    {
        String s = text.getValue();
        if(text.isCDATASection() && s.indexOf("]]>") == -1)
        {
            if(!(escaper instanceof UnicodeWriter))
            {
                int i = s.length();
                for(int j = 0; j < i; j++)
                    if(escaper.needsEscaping(s.charAt(j)))
                    {
                        escaper.writePCDATA(s);
                        return;
                    }

            }
            escaper.writeMarkup("<![CDATA[");
            escaper.writeMarkup(s);
            escaper.writeMarkup("]]>");
        } else
        {
            if(isBoundaryWhitespace(text))
                return;
            escaper.writePCDATA(s);
        }
    }

    private boolean isBoundaryWhitespace(Text text)
    {
        if(getIndent() <= 0)
            return false;
        if(!"".equals(text.getValue().trim()))
            return false;
        ParentNode parentnode = text.getParent();
        int i = parentnode.indexOf(text);
        if(i == 0 && parentnode.getChildCount() == 1)
            return false;
        Node node = null;
        Node node1 = null;
        if(i != 0)
            node = parentnode.getChild(i - 1);
        if(i != parentnode.getChildCount() - 1)
            node1 = parentnode.getChild(i + 1);
        return (node == null || !node.isText()) && (node1 == null || !node1.isText());
    }

    protected void write(DocType doctype)
        throws IOException
    {
        escaper.writeMarkup("<!DOCTYPE ");
        escaper.writeMarkup(doctype.getRootElementName());
        if(doctype.getPublicID() != null)
            escaper.writeMarkup(" PUBLIC \"" + doctype.getPublicID() + "\" \"" + doctype.getSystemID() + "\"");
        else
        if(doctype.getSystemID() != null)
            escaper.writeMarkup(" SYSTEM \"" + doctype.getSystemID() + "\"");
        String s = doctype.getInternalDTDSubset();
        if(!s.equals(""))
        {
            escaper.writeMarkup(" [");
            escaper.breakLine();
            escaper.setInDocType(true);
            escaper.writeMarkup(s);
            escaper.setInDocType(false);
            escaper.writeMarkup("]");
        }
        escaper.writeMarkup(">");
    }

    protected void writeChild(Node node)
        throws IOException
    {
        if(node.isElement())
            write((Element)node);
        else
        if(node.isText())
            write((Text)node);
        else
        if(node.isComment())
            write((Comment)node);
        else
        if(node.isProcessingInstruction())
            write((ProcessingInstruction)node);
        else
        if(node.isDocType())
            write((DocType)node);
        else
            throw new XMLException("Cannot write a " + node.getClass().getName() + " from the writeChildNode() method");
    }

    protected final void writeEscaped(String s)
        throws IOException
    {
        escaper.writePCDATA(s);
    }

    protected final void writeAttributeValue(String s)
        throws IOException
    {
        escaper.writeAttributeValue(s);
    }

    protected final void writeRaw(String s)
        throws IOException
    {
        escaper.writeMarkup(s);
    }

    protected final void breakLine()
        throws IOException
    {
        escaper.breakLine();
    }

    public void flush()
        throws IOException
    {
        escaper.flush();
    }

    public int getIndent()
    {
        return escaper.getIndent();
    }

    public void setIndent(int i)
    {
        if(i < 0)
        {
            throw new IllegalArgumentException("Indent cannot be negative");
        } else
        {
            escaper.setIndent(i);
            return;
        }
    }

    public String getLineSeparator()
    {
        return escaper.getLineSeparator();
    }

    public void setLineSeparator(String s)
    {
        escaper.setLineSeparator(s);
    }

    public int getMaxLength()
    {
        return escaper.getMaxLength();
    }

    public void setMaxLength(int i)
    {
        escaper.setMaxLength(i);
    }

    public boolean getPreserveBaseURI()
    {
        return preserveBaseURI;
    }

    public void setPreserveBaseURI(boolean flag)
    {
        preserveBaseURI = flag;
    }

    public String getEncoding()
    {
        return escaper.getEncoding();
    }

    public void setUnicodeNormalizationFormC(boolean flag)
    {
        escaper.setNFC(flag);
    }

    public boolean getUnicodeNormalizationFormC()
    {
        return escaper.getNFC();
    }

    protected final int getColumnNumber()
    {
        return escaper.getColumnNumber();
    }

    private TextWriter escaper;
    private boolean preserveBaseURI;
}